/**
 * PenguinAttackAIClient.java
 *
 * Description: Driver program to start up the AI and the TCP client.
 *
 * Copyright (c) 2011, Jason Buck
 * 
 * Distributed under the BSD-new license. For details see the BSD_LICENSE file 
 * that should have been included with this distribution. If the source you 
 * acquired this distribution from incorrectly removed this file, the license 
 * may be viewed at http://www.opensource.org/licenses/bsd-license.php.
 */

public class PenguinAttackAIClient
{
	public static void main(String[] args)
    {
        PenguinAttackTCPClient client;
		
        // Check if the command line arguments are the right size.
        if (args.length != 1)
            client = new PenguinAttackTCPClient("127.0.0.1");
        else
			client = new PenguinAttackTCPClient(args[0]);
		
		if(client.isConnected())
		{
			System.out.println("Connected.");
			
			// Spin off networking into its own thread
			Thread networkThread = new Thread(client);
			networkThread.start();
			
			// Instantiate AI
			PenguinAttackAI ai = new PenguinAttackAI(client);
			
			// Lets play some Penguin Attack!
			while(client.isConnected())
				ai.playPenguinAttack();
			
			// Give the network thread time to terminate gracefully
			while (networkThread.isAlive()) 
			{
				try 
				{
					Thread.sleep(50);
				}
				catch (Exception e) 
				{}
			}
		}
		else
			System.out.println("Connection to specified host could not be established.");
		
		// Exit.
		System.exit(0);
    }
}